import 'package:flutter/material.dart';
import 'package:viserpay_agent/data/model/global/formdata/global_keyc_formData.dart';
import 'package:viserpay_agent/view/components/checkbox/custom_check_box.dart';
import 'package:viserpay_agent/view/components/text/label_text.dart';

class KycCheckBoxSection extends StatelessWidget {
  GlobalFormModel model;
  Function onChanged;
  List<String>? selectedValue;
  KycCheckBoxSection({
    super.key,
    required this.model,
    required this.onChanged,
    required this.selectedValue,
  });

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        LabelText(text: model.name ?? '', isRequired: model.isRequired == 'optional' ? false : true, instruction: model.instruction),
        CustomCheckBox(
          selectedValue: selectedValue,
          list: model.options ?? [],
          onChanged: (value) => onChanged(value),
        ),
      ],
    );
  }
}
